# ![](https://i.imgur.com/ljcDWgQ_d.webp?maxwidth=500&fidelity=grand)  
# PidgonScript 
Hello! Welcome to the PidgonScript, a fun, easy and simple-to-use programming language. Read the docs [here](https://pidgonscript.mihi.ml).
Don't see documentation for new commands? Just wait a few minutes and they should be there.
# License
```This work is licensed under the Creative Commons Attribution 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/ or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.```

## PidgonScript Docs

##### Last Updated: 8th September 2021

Version 3.3.0 - Long-Term Support

Hello! Welcome to the PidgonScript Docs! PidgonScript is an easy and fun programming language made by Mihi in one afternoon. It is built on top of node.js. You will only need NPM and node.js installed on your computer/machine.

# Getting Started

There are two ways of using PidgonScript without downloading anything:

### PidgonScript Playground

This is an easy way to use PidgonScript without having to download anything.

Open [Pidgonscript Playground](https://playground.mihi.ml).

The setup is already done for you, so you can try out the examples here.

The only problems with this is you can't have multiple files, and you can't host websites.

### Replit

[Replit](https://replit.com) is an online code sandbox where you can host and run projects.

First, sign up. Then, in the left sidebar, click `New Repl`

Then, in the window that opens, search for `node.js` and select it.

After that, in the title, you can name it whatever you want.

Once you're done, click `Create Repl`

This is your interface. The left bar is for files, the center bar is for  
writing and editing code, and the right bar is for seeing your website and  
the terminal/console

Start by typing these lines in the center bar

`const pidgon = require('pidgonscript')`  
`const noomber = require('pidgonscript/noomber')`  
`pidgon.start()`

Finally, click run, and wait for the packages to load.

This is the best way to use and run PidgonScript.

# Syntax

Syntax are the statements and functions to write in PidgonScript. Here are all the syntaxes on PidgonScript.

## Pidgon.says()

Use pidgon.says() to write something to the console. For example, type in  
`pidgon.says(‘Hello World’)`  
in index.js. Run the file, and the console should print out  
a `Hello World!`

### Pidgon.space()

Use pidgon.space() is an easy way to input a space between two variables/functions in the console. Use it like this:  
`pidgon.says(pidgon.adds(2, 2) + pidgon.space + pidgon.adds(3, 5))`  
This should print out  
`4 8`  
in the console.

## Pidgon.math()

PidgonScript also supports basic mathematic calculations. Here they are:

### Pidgon.adds()

Use pidgon.adds() to add two numbers. for example,  
`pidgon.adds(2, 7)`  
should give you 9\. To print out the result to the console, use  
`pidgon.says(pidgon.adds(2,7))`

### Pidgon.subtracts()

Use pidgon.subtracts() to subtract two numbers. for example,  
`pidgon.adds(7, 2)`  
should give you 5\. To print out the result to the console, use  
`pidgon.says(pidgon.subs(7, 2))`

### Pidgon.multiplies()

Use pidgon.multiplies() to multiply two numbers. for example,  
`pidgon.multiplies(2, 7)`  
should give you 14\. To print out the result to the console, use  
`pidgon.says(pidgon.multiplies(2, 7))`

### Pidgon.divides()

Use pidgon.divides() to divide two numbers. for example,  
`pidgon.divides(10, 5)`  
should give you 2\. To print out the result to the console, use  
`pidgon.says(pidgon.divides(10, 5))`

### Pidgon.random()

Use pidgon.random() to get a random number within a range. For example,  
`pidgon.random(1, 89)` will give you a random number between 1 and 89.

To print the number to the console, use `pidgon.says(pidgon.random(1, 89))`

### Pidgon.roundoff()

In the last function, `pidgon.random()`, you will get a number most likely with a large number of digits following it. To round it off, wrap pidgon.roundoff() around it. for example:  
`pidgon.roundoff(pidgon.random(1, 89)`  
This function does not have to be used only for `pidgon.random`. It can also be used for numbers.

To print a rounded off random number to the console, type in  
`pidgon.says(pidgon.roundoff(pidgon.random(1, 89)))`

## Date and Time

PidgonScript has a date and time system as well. Here are all the functions

##### This is a new function(v1.8.0), so if you you've installed PidgonScript before 11th June 2021, uninstall and re-install the package.

### Pidgon.period()

Use `pidgon.period()` to get the period of the day, for example AM or PM. To print it to the console use:

`pidgon.says(pidgon.says(pidgon.period())`

### Pidgon.hms()

Use `pidgon.hms()` to get the time in the hours:minutes:seconds format. To print it to the console use:

`pidgon.says(pidgon.says(pidgon.hms())`

### Pidgon.second()

Use `pidgon.second()` to get the current second of the minute, from 1 to 59\. To print it to the console use:

`pidgon.says(pidgon.says(pidgon.second())`

### Pidgon.minute()

Use `pidgon.minute()` to get the current minute of the hour, from 1 to 59\. To print it to the console use:

`pidgon.says(pidgon.says(pidgon.minute())`

### Pidgon.hour()

Use `pidgon.hour()` to get the current hour of the day, from 1 to 24\. To print it to the console use:

`pidgon.says(pidgon.says(pidgon.hour())`

### Pidgon.date()

Use `pidgon.date()` to get the date from 1st to 31st. To print it to the console use:

`pidgon.says(pidgon.says(pidgon.date())`

### Pidgon.year()

Use `pidgon.year()` to get the current four-digit year (For example, 2021). To print it to the console use:

`pidgon.says(pidgon.says(pidgon.year())`

### Pidgon.monthname()

Use `pidgon.date()` to get the current month's name(For example, July). To print it to the console use:

`pidgon.says(pidgon.says(pidgon.monthname())`

### Pidgon.monthnumber()

Use `pidgon.monthnumber()` to get the month number from 1 to 12, each corresponding to a month(For example, 3 is March). To print it to the console use:

`pidgon.says(pidgon.says(pidgon.monthnumber())`

### Pidgon.date()

Use `pidgon.date()` to get the date from 1st to 31st. To print it to the console use:

`pidgon.says(pidgon.says(pidgon.date())`

### Pidgon.day()

Use `pidgon.day()` to get the day from Monday to Sunday. To print it to the console use:

`pidgon.says(pidgon.says(pidgon.day())`

## Noomber

Noomber is PidgonScript’s variable handler. It is designed to store your variables in a neat `data.json` file to view.

### Declaring A Variable

#### Declaring a number variable

To declare a number variable called `hello` with the value `956`, type this:  
`noomber.make(“hello”, 956)`

##### Adding to a number variable

To add 5 to a number variable called `'world'`

`noomber.add('world', 5)`

##### Subtracting from a variable

To subtract 5 from a number variable called `'world'`

`noomber.subtract('world', 5)`

#### Declaring a string variable

A `string` is a letter and/or a number. To declare a string variable called `ping` with the value `p0ng`, type this:  
`noomber.make(‘ping’, ‘p0ng’)`

(That `0` in `p0ng` was on purpose, to fully show what a string is)

#### Declaring an Array

An array is a list. To create a list called `fruits` with the items `Apple, Orange`

`noomber.makelist('fruits', ['Apple', 'Orange'])`

##### Adding to an Array

To add an item to an array `fruits` called `banana`,

`noomber.addtolist('fruits', 'banana')`

You can print arrays in the same way as you print string and number variables.

#### Deleting a Variable

To delete a variable called `hello`,

`noomber.delete('hello')`

#### Clearing all Variables

To clear ALL the variables,

`noomber.erase()`

### Getting a Variable

To get a variable called `hello` with the value `956`, type in  
`noomber.take(‘hello’)`

### Turning a string into a list

You can use `noomber.listify()`to turn strings into lists. For example

`noomber.listify('This is a list now', ' ')`

This will separate the sentence from the spaces. If the sentence was `'this/is/a/list/now'`, then you could write  
`noomber.listify('this/is/a/list/now', '/')`

You can print it to the console with:

`pidgon.says(noomber.listify('This is a list now', ' '))`

This will print  
`['This', 'is', 'a', 'list', 'now']`

You can even save it into a list with:

`noomber.makelist('listified', noomber.listify('This is a list now'))`

And print that variable with:

`pidgon.says(noomber.take('listified'))`

### noomber.stringy()

`noomber.string()` changes every number into a string, which makes numbers safe for live servers, etc.

To make text into a string:

`noomber.stringy('normal', 098765432156)`

To make a variable into a string:

`noomber.stringy('variable', 'examplevariable')`

## Square Roots

To find the square root of a number, for example `64`,

`pidgon.says(noomber.squareroot(64))`

This will print `8` to the console.

# CHALLENGE TIME!!

Create a variable called `yay` with the value `256`.  
Use noomber.take() to print the variable to the console

## The answer

Didn’t get it right? Here’s the answer  
`noomber.make(‘hello’, 256)`  
`pidgon.says(noomber.take(‘hello’))`

## Encrypting

There are two ways to encrypt strings in PidgonScript. Here they are:

### Morse Code

You can encrypt your string into morse code with

`pidgon.morseEncode('this will turn into morse code!')`

To decode morse code:

`pidgon.morseDecode('-.-- .- -.-- -.-.--')`

Spaces are shown in morse code with `/`.

You can show the encoded or decoded form in the console with  
`pidgon.says(morseDecode('-.-- .- -.-- -.-.--'))`

### MihiCrypt

MihiCrypt is PidgonScript's very secure encryption method. To encrypt a string:

`pidgon.encrypt('wow very secure')`

To decyrpt a string:

`pidgon.decrypt('4bd43f5d3d6ea30140845cabdd2e892e')`

You can show the result with  
`pidgon.says(pidgon.decrypt('4bd43f5d3d6ea30140845cabdd2e892e'))`

## Webpage Hosting

As of **v2.0.0**, PidgonScript supports live website hosting. To say hello in a live webpage:

`pidgon.textserver('hello', 9000)`

This will host a live text/html page **on your computer** at port `9000`. You can view it at `https://localhost:9000`  
This will not host a page for everyone in the world, but only on your computer.  
To connect to the rest of the world, you can use the [PidgonScript Playground](https://playground.mihi.ml).  
But, if you're a beginner, you should stick with this way for now.

### Getting a variable for a served file

To server a variable onto your server, `noomber.take()` will not work.

Instead, use `noomber.stringy()`. This will work on any of your other previously declared variables with `noomber.make()`

Here is an example

`noomber.make('hello', 'h3ll0 c0mput3r!')`  
`pidgon.textserver(noomber.stringy('variable', 'hello'), 9000))`

### Hosting static files

Static files are files that are loaded by the client from your server. Examples are HTML, JS, and CSS files. First, you will need to create a folder. Let's call it 'public'. Inside public, create a file called `index.html`. Inside that file, type in this code [here](/img.jpeg)

Now, in your `index.js` file, type in:

`pidgon.server('public', 9000)`

This will make public as the main directory for the client. To open your index.html file, open `https://localhost:9000/index.html`. Or, if you want to make index.html the main directory,  
you can replace `'public'` with `'public/index.html'`.

## Questions

This is a way to ask questions to the user, with the console/terminal

### pidgon.askquestion()

This is a basic way to ask questions

`pidgon.askquestion('How are you?', answer => {  
pidgon.says('you said: ' + answer)})`

Run the project, and type your response in the console. It should reply with `you said: response`

### pidgon.linequestion()

This is a way to record every line of a response, and send a new one with the press of the return or enter key

`pidgon.linequestion(answer => {  
pidgon.says('you said: ' + answer)})`

Click run, then type anything in the console, and click enter. You will recieve `you typed: response`

## Delays

You can delay a function in PidgonScript. For example, let's print `hello` after `5000` milliseconds, which is 5 seconds:

`pidgon.delay(5000, then => {`  
`pidgon.says('hello')`  
`})`

## If statements

If, else and function statements are the same as VanillaJS. Here is an example:  
`if(noomber.take(‘hello’) == noomber.take(‘yay’) {`  
`pidgon.says(‘They both are equal!!’)`  
`}`

In English, this translates to: If the variable hello is equal to the variable yay, print ‘they both are equal!!’ To the console.

## Else statements

Lets continue with the if statement example.

`if(noomber.take(‘hello’) == noomber.take(‘yay’) {`  
`pidgon.says(‘They both are equal!!’)`  
`} else {`  
`pidgon.says(‘They arent equal :(`  
`}`

In English, this translates to: If the variable hello is equal to the variable yay, print ‘they both are equal!!’ to the console. Otherwise, print ‘They arent equal’ to the console.

## Functions

Functions are a compact way to write multiple commands, and call it with just one line. For example:

`function sayHi() {`  
`pidgon.says('hello')`  
`}`  

In English, this translates to: Make a function called sayHi with the contents: Print hello to the console.

To call the function, type:

`sayHi()`

# Support

Found a bug? Email me at [mihirmaroju@icloud.com](mailto:mihirmaroju@icloud.com)

# Thank you for reading!
